/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.DpResourceState;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.I18NStringTranslated;
import ibm.nways.jdm.StatusType;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;

public class PerformanceEvent
extends PollingObjectInstance
implements Serializable,
DpResourceState {
    public static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    public static final int ARMED = 1;
    public static final int REARMED = 2;
    public static final int REALTIME = 4;
    public static final int CLEARED = 8;
    public static final int UNMANAGED = 16;
    public static final int RESOURCE_EVENT = 32;
    public static final int POLLING_EVENT = 64;
    public static final String ARMED_S = adminRB.getString("s_ARMED");
    public static final String REARMED_S = adminRB.getString("s_REARMED");
    public static final String REALTIME_S = adminRB.getString("s_REALTIME");
    public static final String CLEARED_S = adminRB.getString("s_CLEARED");
    public static final String UNMANAGED_S = adminRB.getString("s_UNMANAGED");
    public static final String RESOURCE_EVENT_S = adminRB.getString("s_RESOURCE_EVENT");
    public static final String POLLING_EVENT_S = adminRB.getString("s_POLLING_EVENT");
    private int eventCause;
    private long eventTime;
    private int eventType;

    public PerformanceEvent(int n, String string, String string2, Vector vector, long l, long l2) {
        super(string, string2, vector, l);
        this.eventCause = n;
        this.eventTime = l2;
        this.eventType = 64;
    }

    public PerformanceEvent(int n, String string, String string2, long l) {
        super(string, null, string2);
        this.eventType = 32;
        this.eventCause = n;
        this.eventTime = l;
    }

    public int getEventType() {
        return this.eventType;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public String getEventName() {
        return super.getIdentifier();
    }

    public int getCause() {
        return this.eventCause;
    }

    public void setCause(int n) {
        this.eventCause = n;
    }

    public void clear() {
        this.eventCause = 8;
    }

    public DataPoint getDataPoint() {
        DataPoint dataPoint = null;
        Vector vector = this.getHistory();
        if (vector != null) {
            dataPoint = (DataPoint)vector.elementAt(0);
        }
        return dataPoint;
    }

    public static int toInt(String string) {
        if (string.equals(ARMED_S)) {
            return 1;
        }
        if (string.equals(REARMED_S)) {
            return 2;
        }
        if (string.equals(REALTIME_S)) {
            return 4;
        }
        if (string.equals(CLEARED_S)) {
            return 8;
        }
        if (string.equals(RESOURCE_EVENT_S)) {
            return 32;
        }
        if (string.equals(POLLING_EVENT_S)) {
            return 64;
        }
        return -1;
    }

    public static String toString(int n) {
        String string;
        switch (n) {
            case 1: {
                string = ARMED_S;
                break;
            }
            case 2: {
                string = REARMED_S;
                break;
            }
            case 4: {
                string = REALTIME_S;
                break;
            }
            case 8: {
                string = CLEARED_S;
                break;
            }
            case 16: {
                string = UNMANAGED_S;
                break;
            }
            case 32: {
                string = RESOURCE_EVENT_S;
                break;
            }
            case 64: {
                string = POLLING_EVENT_S;
                break;
            }
            default: {
                string = "INVALID CAUSE";
            }
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Type: ");
        stringBuffer.append(PerformanceEvent.toString(this.eventType));
        stringBuffer.append("\nCause: ");
        stringBuffer.append(PerformanceEvent.toString(this.eventCause));
        stringBuffer.append("\nTime: ");
        Date date = new Date(this.eventTime);
        stringBuffer.append("\n" + date);
        stringBuffer.append("\n" + super.toString());
        return stringBuffer.toString();
    }

    public String toLineString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name : ");
        stringBuffer.append(super.getIdentifier());
        stringBuffer.append(" cause : ");
        stringBuffer.append(PerformanceEvent.toString(this.eventCause));
        stringBuffer.append(" hostname : ");
        stringBuffer.append(super.getHostname());
        stringBuffer.append(" time = ");
        Date date = new Date(this.eventTime);
        stringBuffer.append(date);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public I18NString getName() {
        String string = String.valueOf(this.getHostname()) + "." + this.getIdentifier();
        Vector vector = this.getHistory();
        if (vector != null && vector.size() > 0) {
            String string2 = null;
            DataPoint dataPoint = (DataPoint)vector.elementAt(0);
            string2 = dataPoint.getID();
            if (string2 != null && string2.length() > 0) {
                string = string.concat("." + string2);
            }
        }
        return new I18NStringTranslated(string);
    }

    public StatusType getStatusType() {
        StatusType statusType = StatusType.UNKNOWN;
        switch (this.eventCause) {
            case 1: {
                statusType = StatusType.CRITICAL;
                break;
            }
            case 2: 
            case 8: {
                statusType = StatusType.NORMAL;
                break;
            }
            case 16: {
                statusType = StatusType.UNMANAGED;
                break;
            }
        }
        return statusType;
    }

    public I18NString getExplanation() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        dateFormat.setTimeZone(TimeZone.getDefault());
        Date date = new Date();
        if (this.eventTime != 0L) {
            date = new Date(this.eventTime);
        }
        String string = String.valueOf(dateFormat.format(date)) + " " + this.getName().getTranslation() + ": ";
        switch (this.eventCause) {
            case 1: {
                string = string.concat(adminRB.getString("s_StatusArmedMessage"));
                break;
            }
            case 2: 
            case 8: {
                string = string.concat(adminRB.getString("s_StatusNormalMessage"));
                break;
            }
            case 16: {
                string = string.concat(adminRB.getString("s_StatusUnmanagedMessage"));
                break;
            }
            default: {
                string = string.concat(adminRB.getString("s_StatusDefaultMessage"));
            }
        }
        return new I18NStringTranslated(string);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof PollingObjectInstance) {
            bl = this.equalsPollingObjectInstance((PollingObjectInstance)object);
        }
        if (object instanceof PerformanceEvent && bl) {
            PerformanceEvent performanceEvent = (PerformanceEvent)object;
            if (this.eventCause != performanceEvent.eventCause || this.eventTime != performanceEvent.eventTime || this.eventType != performanceEvent.eventType) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean equalsPollingObjectInstance(PollingObjectInstance pollingObjectInstance) {
        return super.equals(pollingObjectInstance);
    }
}

